use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\International Data September 2016\Data\fullvars_stack.dta", clear

rename name bank 

gen country = " " 

replace country = "uk" if bank == "hsbc" | bank == "barclays" | bank == "lloyds" | bank == "rbs" | bank == "standchart" 

replace country = "france" if bank == "bnp" | bank == "agricole" | bank == "societe" | bank == "natixis" 

replace country = "japan" if bank == "mitsu" | bank == "mizuho" | bank == "sumitomo" 

replace country = "germany" if bank == "deusche" | bank == "commerz" | bank == "kfw"

replace country = "spain" if bank == "santander" 

replace country = "switzerland" if bank == "ubs" | bank == "creditsui" 

replace country = "italy" if bank == "unicredit" | bank == "intesa" 

replace country = "netherlands" if bank == "ing" | bank == "rabbob" 

replace country = "canada" if bank == "toronto" | bank == "rbc" | bank == "novascotia" | bank == "bankmontreal" 

replace country = "australia" if bank == "ausnzbank" | bank == "natlaust" | bank == "westpac" 

replace country = "brazil" if bank == "bancobrazil"

replace country = "sweden" if bank == "nordea" 

replace country = "denmark" if bank == "danske"

br if country == " " 

drop if country == " "

**** now we want country averages, pre, post, 2015 for (1) mve/assets; (2) mve/risk assets 
generate crisis = . 
replace crisis = 0 if year >= 2002 & year <= 2007 
replace crisis = 1 if year >= 2010 & year <= 2015
replace crisis = . if year == 2002 & bank == "nordea" 

gen mve = shrout*price 

gen mve_div_assets = mve/assets

gen mve_div_risk=mve/risk_assets

by country crisis, sort: egen mve_div_assets_crisis = mean(mve_div_assets)
by country crisis, sort: egen mve_div_risk_crisis = mean(mve_div_risk)
by country crisis, sort: egen tangible_crisis = mean(tangible)

drop output_indicator 

by crisis country, sort: gen output_indicator = _n 

br crisis country mve_div_assets_crisis mve_div_risk_crisis tangible_crisis if output_indicator == 1 & crisis != . 

*** now we want overall mean and median 
capture drop output_indicator 
by crisis, sort: gen output_indicator = _n 
by crisis, sort: egen mve_div_assets_overall = mean(mve_div_assets)
by crisis, sort: egen mve_div_assets_overall_median = median(mve_div_assets)
by crisis, sort: egen mve_div_risk_overall = mean(mve_div_risk)
by crisis, sort: egen mve_div_risk_overall_median = median(mve_div_risk)
by crisis, sort: egen tangible_overall = mean(tangible)
by crisis, sort: egen tangible_overall_median = median(tangible)

br mve_div_assets_overall mve_div_assets_overall_median mve_div_risk_overall mve_div_risk_overall_median tangible_overall tangible_overall_median if output_indicator == 1 & crisis != .  

**** annual averages 
drop output_indicator 

by country year, sort: egen mve_div_assets_annual = mean(mve_div_assets)
by country year, sort: egen mve_div_risk_annual = mean(mve_div_risk)
by country year, sort: egen tangible_annual = mean(tangible)

by year country, sort: gen output_indicator = _n 
br crisis year country mve_div_assets_annual mve_div_risk_annual tangible_annual if (year == 2015 & output_indicator == 1)

*** now we want year mean and median 
capture drop output_indicator 
by year, sort: gen output_indicator = _n 
by year, sort: egen mve_div_assets_year = mean(mve_div_assets)
by year, sort: egen mve_div_assets_year_median = median(mve_div_assets)
by year, sort: egen mve_div_risk_year = mean(mve_div_risk)
by year, sort: egen mve_div_risk_year_median = median(mve_div_risk)
by year, sort: egen tangible_year = mean(tangible)
by year, sort: egen tangible_year_median = median(tangible)

br mve_div_assets_year mve_div_assets_year_median mve_div_risk_year mve_div_risk_year_median tangible_year tangible_year_median if output_indicator == 1 & year == 2015 
